Behaviour is a simple tool that runs within Angie application and lets you monitor user behaviour of interest (like user log in, project creation, usage of forgot password feature etc).

In order to track behaviour, Angie offers three key concepts:

1. **Event** - record when something happened,
2. **Intent** - record when user started with an operation,
3. **Fulfilment** - moment when user completes intended action (intent gets converted to event).

### Tracking Events

In order to track an event, you can simply call:

<{code highlight=php}>AngieApplication::behaviour()->record('new_user_session', array(
  'user_' . $user->getId(), 
  'tag2', 
  'tag3'
));<{/code}>

This function accepts three parameters:

1. <{code}>$event_class<{/code}> (required) - name of the event in underscore notation,
2. <{code}>$event_tags<{/code}> (optional) - one or more of event tags, 
3. <{code}>$timestamp<{/code}> (optional) - integer timestamp when event happened. If omitted, current timestamp (<{code}>time()<{/code}>) will be used.

### Tracking Intents and Fulfilments

Intents are a simple concept that let you track when users start a particular operation or process and when they complete it (if ever). When intent gets recorded, system returns intent ID that you can use to track intent fulfilment:

<{code highlight=xml}><input type="hidden" name="_intent_id" 
  value="{AngieApplication::behaviour()->recordIntent('task_created', 'tag1,tag2', $timestamp)}"><{/code}>

This method accepts same parameters as <{code}>record()<{/code}> method because intent becomes event once user fulfils their intent. <{code}>$event_tags<{/code}> and <{code}>$timestamp<{/code}> are optional.

Once user submits the form, we can tell the system to "convert" the intent to an event:

<{code highlight=php}>AngieApplication::behaviour()->recordFulfilment($this->request->post('_intent_id'), array('extra_tag_1', 'extra_tag_2'), null, function() {
  return array('task_created', array('extra_tag_1', 'extra_tag_2'));
});<{/code}>

When intent is fulfilled, system remembers intent time (so we can see how much time user spent between intention and fulfilment) and moves event class and event tags from intent to an event.

Unlike <{code}>record()<{/code}> and <{code}>recordIntent()<{/code}> methods which have the same input parameters, <{code}>recordFulfilment()<{/code}> accepts a different set of parameters:

1. <{code}>$intent_id<{/code}> (optional) - ID of recorded intent,
2. <{code}>$extra_event_tags<{/code}> (optional) - Extra tags that you want to add to the event. This is useful for situations when not all tags are known in the time of the intent (like whether project is created from a template or not), but are known when intent gets fulfilled,
3. <{code}>$timestamp<{/code}> (optional) - Timestamp when intent got fulfilled. If omitted, system will use current time (simple <{code}>time()<{/code}> call),
4. <{code}>$on_intent_not_found<{/code}> (optional) - Closure that is called when intent with <{code}>$intent_id<{/code}> was not found. This function returns an array of one, two or three parameters, each corresponding to parameters of <{code}>record()<{/code}> method.

Third parameter is useful when you want to record an event even when there is possibility that intent ID is not present (like events that are trigged via API) or that it is not found (for some reason, we don't have the targeted intent in the backend).